/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.notifs;

import com.utility.DbLogin;
import com.webhook.dto.ChangeNotificationModel;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.events.ChangeStructParser;
import com.webhook.events.ChangedFieldsGeneratorFactory;
import com.webhook.util.CDCTables;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CDCBaseNotification {
    public final ChangeStructParser parser;
    private final ChangedFieldsGeneratorFactory changedFieldsFactory;
    public List<Map<String, Object>> allChangedRows = new ArrayList();
    public Envelope.Operation operation;
    public String changedTableName;
    public Map<String, Object> changedFields;

    public CDCBaseNotification(ChangeStructParser parser, Envelope.Operation operation) {
        this.parser = parser;
        this.operation = operation;
        this.changedFieldsFactory = new ChangedFieldsGeneratorFactory(DbLogin.getInstance());
    }

    public void generateChangedFields() throws InterruptedException {
        CDCTables table = this.parser.getChangedTable();
        BaseChangeFieldGenerator generator = this.changedFieldsFactory.getChangedFieldGenerator(table);
        this.setChangedFields(generator.generateChangedFields(this));
        this.finalSetups();
    }

    private void finalSetups() {
        CDCTables changedTable = this.parser.getChangedTable();
        this.setChangedTable(changedTable.getFinalChangeTableName());
        if (!changedTable.isMainTable()) {
            this.operation = Envelope.Operation.UPDATE;
        } else if (this.parser.isFoodPrepared()) {
            this.setChangedTable("pager");
        }
    }

    public ChangeNotificationModel makeNotification() {
        CDCTables table = CDCTables.getTable((String)this.changedTableName);
        String[] urlKey = this.parser.getUrlAndAPIKey(this.changedTableName);
        ChangeNotificationModel.ChangeNotificationModelBuilder notification = ChangeNotificationModel.builder().dbname(this.parser.getLogin().getDatabaseName()).url(urlKey[0]).apiKey(urlKey[1]).tableName(table.getTableToShow()).crudOperation(this.operation.toString()).changedFields(this.allChangedRows);
        return notification.build();
    }

    private void setChangedTable(String changedTable) {
        this.changedTableName = changedTable;
    }

    private void setChangedFields(Map<String, Object> changedFields) {
        this.changedFields = changedFields;
        this.allChangedRows.add(changedFields);
    }

    public void addAllChangedRows(Map<String, Object> row) {
        boolean duplicateReplaced = false;
        for (Map change : this.allChangedRows) {
            String codeField = this.parser.getChangedTable().getTableCodeFieldToShow();
            String c1 = change.get(codeField).toString();
            String c2 = row.get(codeField).toString();
            if (c1 == null || !c1.equalsIgnoreCase(c2)) continue;
            change.putAll(row);
            duplicateReplaced = true;
            break;
        }
        if (!duplicateReplaced) {
            this.allChangedRows.add(row);
        }
    }

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        CDCTables table = this.parser.getChangedTable();
        BaseChangeFieldGenerator generator = this.changedFieldsFactory.getChangedFieldGenerator(table);
        return generator.mergeNotifications(notifications);
    }

    public ChangeStructParser getParser() {
        return this.parser;
    }

    public List<Map<String, Object>> getAllChangedRows() {
        return this.allChangedRows;
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    public String getChangedTableName() {
        return this.changedTableName;
    }

    public void setChangedTableName(String changedTableName) {
        this.changedTableName = changedTableName;
    }

    public Map<String, Object> getChangedFields() {
        return this.changedFields;
    }
}

